/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "TwoTone.HomeWork") {
            materialPath {
                moveTo(17.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(13.74f, 7.0f)
                lineToRelative(1.26f, 0.84f)
                verticalLineTo(7.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                verticalLineToRelative(1.51f)
                lineToRelative(2.0f, 1.33f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(3.0f)
                close()
            }
            materialPath {
                moveTo(8.17f, 5.7f)
                lineTo(15.0f, 10.25f)
                verticalLineTo(21.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(10.48f)
                lineTo(8.17f, 5.7f)
                close()
                moveTo(10.0f, 19.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-7.84f)
                lineTo(8.17f, 8.09f)
                lineTo(3.0f, 11.38f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(6.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.0f, 19.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-7.84f)
                lineTo(8.17f, 8.09f)
                lineTo(3.0f, 11.38f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(4.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
