/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SettingsSuggest: ImageVector
    get() {
        if (_settingsSuggest != null) {
            return _settingsSuggest!!
        }
        _settingsSuggest = materialIcon(name = "TwoTone.SettingsSuggest") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.07f, 15.23f)
                curveToRelative(0.12f, -0.39f, 0.18f, -0.8f, 0.18f, -1.23f)
                curveToRelative(0.0f, -0.43f, -0.06f, -0.84f, -0.18f, -1.23f)
                lineToRelative(1.49f, -1.13f)
                lineToRelative(-0.73f, -1.27f)
                lineToRelative(-1.73f, 0.73f)
                curveToRelative(-0.56f, -0.6f, -1.3f, -1.04f, -2.13f, -1.23f)
                lineTo(10.73f, 8.0f)
                horizontalLineTo(9.27f)
                lineTo(9.03f, 9.86f)
                curveToRelative(-0.83f, 0.19f, -1.57f, 0.63f, -2.13f, 1.23f)
                lineToRelative(-1.73f, -0.73f)
                lineToRelative(-0.73f, 1.27f)
                lineToRelative(1.49f, 1.13f)
                curveToRelative(-0.12f, 0.39f, -0.18f, 0.8f, -0.18f, 1.23f)
                curveToRelative(0.0f, 0.43f, 0.06f, 0.84f, 0.18f, 1.23f)
                lineToRelative(-1.49f, 1.13f)
                lineToRelative(0.73f, 1.27f)
                lineToRelative(1.73f, -0.73f)
                curveToRelative(0.56f, 0.6f, 1.3f, 1.04f, 2.13f, 1.23f)
                lineTo(9.27f, 20.0f)
                horizontalLineToRelative(1.47f)
                lineToRelative(0.23f, -1.86f)
                curveToRelative(0.83f, -0.19f, 1.57f, -0.63f, 2.13f, -1.23f)
                lineToRelative(1.73f, 0.73f)
                lineToRelative(0.73f, -1.27f)
                lineTo(14.07f, 15.23f)
                close()
                moveTo(10.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(11.66f, 17.0f, 10.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 13.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(9.45f, 13.0f, 10.0f, 13.0f)
                moveTo(10.0f, 11.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(11.66f, 11.0f, 10.0f, 11.0f)
                lineTo(10.0f, 11.0f)
                close()
                moveTo(18.5f, 9.0f)
                lineToRelative(1.09f, -2.41f)
                lineTo(22.0f, 5.5f)
                lineToRelative(-2.41f, -1.09f)
                lineTo(18.5f, 2.0f)
                lineToRelative(-1.09f, 2.41f)
                lineTo(15.0f, 5.5f)
                lineToRelative(2.41f, 1.09f)
                lineTo(18.5f, 9.0f)
                close()
                moveTo(21.28f, 12.72f)
                lineTo(20.5f, 11.0f)
                lineToRelative(-0.78f, 1.72f)
                lineTo(18.0f, 13.5f)
                lineToRelative(1.72f, 0.78f)
                lineTo(20.5f, 16.0f)
                lineToRelative(0.78f, -1.72f)
                lineTo(23.0f, 13.5f)
                lineTo(21.28f, 12.72f)
                close()
                moveTo(16.25f, 14.0f)
                curveToRelative(0.0f, -0.12f, 0.0f, -0.25f, -0.01f, -0.37f)
                lineToRelative(1.94f, -1.47f)
                lineToRelative(-2.5f, -4.33f)
                lineToRelative(-2.24f, 0.94f)
                curveToRelative(-0.2f, -0.13f, -0.42f, -0.26f, -0.64f, -0.37f)
                lineTo(12.5f, 6.0f)
                horizontalLineToRelative(-5.0f)
                lineTo(7.2f, 8.41f)
                curveTo(6.98f, 8.52f, 6.77f, 8.65f, 6.56f, 8.78f)
                lineTo(4.32f, 7.83f)
                lineToRelative(-2.5f, 4.33f)
                lineToRelative(1.94f, 1.47f)
                curveTo(3.75f, 13.75f, 3.75f, 13.88f, 3.75f, 14.0f)
                reflectiveCurveToRelative(0.0f, 0.25f, 0.01f, 0.37f)
                lineToRelative(-1.94f, 1.47f)
                lineToRelative(2.5f, 4.33f)
                lineToRelative(2.24f, -0.94f)
                curveToRelative(0.2f, 0.13f, 0.42f, 0.26f, 0.64f, 0.37f)
                lineTo(7.5f, 22.0f)
                horizontalLineToRelative(5.0f)
                lineToRelative(0.3f, -2.41f)
                curveToRelative(0.22f, -0.11f, 0.43f, -0.23f, 0.64f, -0.37f)
                lineToRelative(2.24f, 0.94f)
                lineToRelative(2.5f, -4.33f)
                lineToRelative(-1.94f, -1.47f)
                curveTo(16.25f, 14.25f, 16.25f, 14.12f, 16.25f, 14.0f)
                close()
                moveTo(14.83f, 17.64f)
                lineToRelative(-1.73f, -0.73f)
                curveToRelative(-0.56f, 0.6f, -1.3f, 1.04f, -2.13f, 1.23f)
                lineTo(10.73f, 20.0f)
                horizontalLineTo(9.27f)
                lineToRelative(-0.23f, -1.86f)
                curveToRelative(-0.83f, -0.19f, -1.57f, -0.63f, -2.13f, -1.23f)
                lineToRelative(-1.73f, 0.73f)
                lineToRelative(-0.73f, -1.27f)
                lineToRelative(1.49f, -1.13f)
                curveToRelative(-0.12f, -0.39f, -0.18f, -0.8f, -0.18f, -1.23f)
                curveToRelative(0.0f, -0.43f, 0.06f, -0.84f, 0.18f, -1.23f)
                lineToRelative(-1.49f, -1.13f)
                lineToRelative(0.73f, -1.27f)
                lineToRelative(1.73f, 0.73f)
                curveToRelative(0.56f, -0.6f, 1.3f, -1.04f, 2.13f, -1.23f)
                lineTo(9.27f, 8.0f)
                horizontalLineToRelative(1.47f)
                lineToRelative(0.23f, 1.86f)
                curveToRelative(0.83f, 0.19f, 1.57f, 0.63f, 2.13f, 1.23f)
                lineToRelative(1.73f, -0.73f)
                lineToRelative(0.73f, 1.27f)
                lineToRelative(-1.49f, 1.13f)
                curveToRelative(0.12f, 0.39f, 0.18f, 0.8f, 0.18f, 1.23f)
                curveToRelative(0.0f, 0.43f, -0.06f, 0.84f, -0.18f, 1.23f)
                lineToRelative(1.49f, 1.13f)
                lineTo(14.83f, 17.64f)
                close()
            }
        }
        return _settingsSuggest!!
    }

private var _settingsSuggest: ImageVector? = null
