/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AppRegistration: ImageVector
    get() {
        if (_appRegistration != null) {
            return _appRegistration!!
        }
        _appRegistration = materialIcon(name = "Filled.AppRegistration") {
            materialPath {
                moveTo(10.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 16.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 10.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 12.42f)
                lineToRelative(0.0f, -2.42f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(2.42f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.88f, 11.29f)
                lineToRelative(-1.17f, -1.17f)
                curveToRelative(-0.16f, -0.16f, -0.42f, -0.16f, -0.58f, 0.0f)
                lineTo(18.25f, 11.0f)
                lineTo(20.0f, 12.75f)
                lineToRelative(0.88f, -0.88f)
                curveTo(21.04f, 11.71f, 21.04f, 11.45f, 20.88f, 11.29f)
                close()
            }
            materialPath {
                moveTo(11.0f, 18.25f)
                lineToRelative(0.0f, 1.75f)
                lineToRelative(1.75f, 0.0f)
                lineToRelative(6.67f, -6.67f)
                lineToRelative(-1.75f, -1.75f)
                close()
            }
            materialPath {
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
        }
        return _appRegistration!!
    }

private var _appRegistration: ImageVector? = null
