/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NetworkCell: ImageVector
    get() {
        if (_networkCell != null) {
            return _networkCell!!
        }
        _networkCell = materialIcon(name = "Filled.NetworkCell") {
            materialPath {
                moveTo(2.0f, 22.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                lineTo(2.0f, 22.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(9.83f)
                lineToRelative(3.0f, -3.0f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _networkCell!!
    }

private var _networkCell: ImageVector? = null
