/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PanoramaWideAngle: ImageVector
    get() {
        if (_panoramaWideAngle != null) {
            return _panoramaWideAngle!!
        }
        _panoramaWideAngle = materialIcon(name = "Filled.PanoramaWideAngle") {
            materialPath {
                moveTo(12.0f, 6.0f)
                curveToRelative(2.45f, 0.0f, 4.71f, 0.2f, 7.29f, 0.64f)
                curveToRelative(0.47f, 1.78f, 0.71f, 3.58f, 0.71f, 5.36f)
                curveToRelative(0.0f, 1.78f, -0.24f, 3.58f, -0.71f, 5.36f)
                curveToRelative(-2.58f, 0.44f, -4.84f, 0.64f, -7.29f, 0.64f)
                reflectiveCurveToRelative(-4.71f, -0.2f, -7.29f, -0.64f)
                curveTo(4.24f, 15.58f, 4.0f, 13.78f, 4.0f, 12.0f)
                curveToRelative(0.0f, -1.78f, 0.24f, -3.58f, 0.71f, -5.36f)
                curveTo(7.29f, 6.2f, 9.55f, 6.0f, 12.0f, 6.0f)
                moveToRelative(0.0f, -2.0f)
                curveToRelative(-2.73f, 0.0f, -5.22f, 0.24f, -7.95f, 0.72f)
                lineToRelative(-0.93f, 0.16f)
                lineToRelative(-0.25f, 0.9f)
                curveTo(2.29f, 7.85f, 2.0f, 9.93f, 2.0f, 12.0f)
                reflectiveCurveToRelative(0.29f, 4.15f, 0.87f, 6.22f)
                lineToRelative(0.25f, 0.89f)
                lineToRelative(0.93f, 0.16f)
                curveToRelative(2.73f, 0.49f, 5.22f, 0.73f, 7.95f, 0.73f)
                reflectiveCurveToRelative(5.22f, -0.24f, 7.95f, -0.72f)
                lineToRelative(0.93f, -0.16f)
                lineToRelative(0.25f, -0.89f)
                curveToRelative(0.58f, -2.08f, 0.87f, -4.16f, 0.87f, -6.23f)
                reflectiveCurveToRelative(-0.29f, -4.15f, -0.87f, -6.22f)
                lineToRelative(-0.25f, -0.89f)
                lineToRelative(-0.93f, -0.16f)
                curveTo(17.22f, 4.24f, 14.73f, 4.0f, 12.0f, 4.0f)
                close()
            }
        }
        return _panoramaWideAngle!!
    }

private var _panoramaWideAngle: ImageVector? = null
