/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Recycling: ImageVector
    get() {
        if (_recycling != null) {
            return _recycling!!
        }
        _recycling = materialIcon(name = "Filled.Recycling") {
            materialPath {
                moveTo(5.77f, 7.15f)
                lineTo(7.2f, 4.78f)
                lineToRelative(1.03f, -1.71f)
                curveToRelative(0.39f, -0.65f, 1.33f, -0.65f, 1.72f, 0.0f)
                lineToRelative(1.48f, 2.46f)
                lineToRelative(-1.23f, 2.06f)
                lineTo(9.2f, 9.21f)
                lineTo(5.77f, 7.15f)
                close()
                moveTo(21.72f, 12.97f)
                lineToRelative(-1.6f, -2.66f)
                lineToRelative(-3.46f, 2.0f)
                lineTo(18.87f, 16.0f)
                horizontalLineTo(20.0f)
                curveToRelative(0.76f, 0.0f, 1.45f, -0.43f, 1.79f, -1.11f)
                curveTo(21.93f, 14.61f, 22.0f, 14.31f, 22.0f, 14.0f)
                curveTo(22.0f, 13.64f, 21.9f, 13.29f, 21.72f, 12.97f)
                close()
                moveTo(16.0f, 21.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.76f, 0.0f, 1.45f, -0.43f, 1.79f, -1.11f)
                lineTo(20.74f, 17.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(4.0f, 4.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(10.0f, 17.0f)
                horizontalLineTo(5.7f)
                lineToRelative(-0.84f, 1.41f)
                curveToRelative(-0.3f, 0.5f, -0.32f, 1.12f, -0.06f, 1.65f)
                lineToRelative(0.0f, 0.0f)
                curveTo(5.08f, 20.63f, 5.67f, 21.0f, 6.32f, 21.0f)
                horizontalLineTo(10.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(6.12f, 14.35f)
                lineToRelative(1.73f, 1.04f)
                lineTo(6.48f, 9.9f)
                lineTo(1.0f, 11.27f)
                lineToRelative(1.7f, 1.02f)
                lineToRelative(-0.41f, 0.69f)
                curveToRelative(-0.35f, 0.59f, -0.38f, 1.31f, -0.07f, 1.92f)
                lineToRelative(1.63f, 3.26f)
                lineTo(6.12f, 14.35f)
                close()
                moveTo(17.02f, 5.14f)
                lineToRelative(-1.3f, -2.17f)
                curveTo(15.35f, 2.37f, 14.7f, 2.0f, 14.0f, 2.0f)
                horizontalLineToRelative(-3.53f)
                lineToRelative(3.12f, 5.2f)
                lineToRelative(-1.72f, 1.03f)
                lineToRelative(5.49f, 1.37f)
                lineToRelative(1.37f, -5.49f)
                lineTo(17.02f, 5.14f)
                close()
            }
        }
        return _recycling!!
    }

private var _recycling: ImageVector? = null
