/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ScreenSearchDesktop: ImageVector
    get() {
        if (_screenSearchDesktop != null) {
            return _screenSearchDesktop!!
        }
        _screenSearchDesktop = materialIcon(name = "Filled.ScreenSearchDesktop") {
            materialPath {
                moveTo(20.0f, 18.0f)
                curveTo(21.1f, 18.0f, 21.99f, 17.1f, 21.99f, 16.0f)
                lineTo(22.0f, 6.0f)
                curveTo(22.0f, 4.89f, 21.1f, 4.0f, 20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveTo(2.89f, 4.0f, 2.0f, 4.89f, 2.0f, 6.0f)
                lineTo(2.0f, 16.0f)
                curveTo(2.0f, 17.1f, 2.89f, 18.0f, 4.0f, 18.0f)
                lineTo(0.0f, 18.0f)
                lineTo(0.0f, 20.0f)
                lineTo(24.0f, 20.0f)
                lineTo(24.0f, 18.0f)
                lineTo(20.0f, 18.0f)
                close()
                moveTo(4.0f, 16.0f)
                lineTo(4.0f, 6.0f)
                lineTo(20.0f, 6.0f)
                lineTo(20.0f, 16.0f)
                lineTo(20.0f, 16.01f)
                lineTo(4.0f, 16.0f)
                close()
                moveTo(9.0967f, 9.9531f)
                curveTo(9.0967f, 8.9261f, 9.9327f, 8.0891f, 10.9607f, 8.0891f)
                curveTo(11.9877f, 8.0891f, 12.8247f, 8.9261f, 12.8247f, 9.9531f)
                curveTo(12.8247f, 10.9801f, 11.9877f, 11.8171f, 10.9607f, 11.8171f)
                curveTo(9.9327f, 11.8171f, 9.0967f, 10.9801f, 9.0967f, 9.9531f)
                close()
                moveTo(16.1287f, 14.1891f)
                lineTo(13.6467f, 11.7071f)
                curveTo(13.9777f, 11.2021f, 14.1737f, 10.6001f, 14.1737f, 9.9531f)
                curveTo(14.1737f, 8.1811f, 12.7327f, 6.7401f, 10.9607f, 6.7401f)
                curveTo(9.1887f, 6.7401f, 7.7467f, 8.1811f, 7.7467f, 9.9531f)
                curveTo(7.7467f, 11.7251f, 9.1887f, 13.1671f, 10.9607f, 13.1671f)
                curveTo(11.5967f, 13.1671f, 12.1857f, 12.9751f, 12.6847f, 12.6561f)
                lineTo(15.1737f, 15.1441f)
                lineTo(16.1287f, 14.1891f)
                close()
            }
        }
        return _screenSearchDesktop!!
    }

private var _screenSearchDesktop: ImageVector? = null
