/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TextRotationDown: ImageVector
    get() {
        if (_textRotationDown != null) {
            return _textRotationDown!!
        }
        _textRotationDown = materialIcon(name = "Filled.TextRotationDown") {
            materialPath {
                moveTo(21.0f, 12.0f)
                verticalLineToRelative(-1.5f)
                lineTo(10.0f, 5.75f)
                verticalLineToRelative(2.1f)
                lineToRelative(2.2f, 0.9f)
                verticalLineToRelative(5.0f)
                lineToRelative(-2.2f, 0.9f)
                verticalLineToRelative(2.1f)
                lineTo(21.0f, 12.0f)
                close()
                moveTo(14.0f, 9.38f)
                lineToRelative(5.02f, 1.87f)
                lineTo(14.0f, 13.12f)
                lineTo(14.0f, 9.38f)
                close()
                moveTo(6.0f, 19.75f)
                lineToRelative(3.0f, -3.0f)
                lineTo(7.0f, 16.75f)
                lineTo(7.0f, 4.25f)
                lineTo(5.0f, 4.25f)
                verticalLineToRelative(12.5f)
                lineTo(3.0f, 16.75f)
                lineToRelative(3.0f, 3.0f)
                close()
            }
        }
        return _textRotationDown!!
    }

private var _textRotationDown: ImageVector? = null
