/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WorkOff: ImageVector
    get() {
        if (_workOff != null) {
            return _workOff!!
        }
        _workOff = materialIcon(name = "Filled.WorkOff") {
            materialPath {
                moveTo(23.0f, 21.74f)
                lineToRelative(-1.46f, -1.46f)
                lineTo(7.21f, 5.95f)
                lineTo(3.25f, 1.99f)
                lineTo(1.99f, 3.25f)
                lineToRelative(2.7f, 2.7f)
                horizontalLineToRelative(-0.64f)
                curveToRelative(-1.11f, 0.0f, -1.99f, 0.89f, -1.99f, 2.0f)
                lineToRelative(-0.01f, 11.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(15.64f)
                lineTo(21.74f, 23.0f)
                lineTo(23.0f, 21.74f)
                close()
                moveTo(22.0f, 7.95f)
                curveToRelative(0.05f, -1.11f, -0.84f, -2.0f, -1.95f, -1.95f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(3.95f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -1.95f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-1.11f, -0.05f, -2.0f, 0.84f, -2.0f, 1.95f)
                verticalLineToRelative(0.32f)
                lineToRelative(13.95f, 14.0f)
                verticalLineTo(7.95f)
                close()
                moveTo(14.05f, 6.0f)
                horizontalLineTo(10.0f)
                verticalLineTo(3.95f)
                horizontalLineToRelative(4.05f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _workOff!!
    }

private var _workOff: ImageVector? = null
