/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DownloadDone: ImageVector
    get() {
        if (_downloadDone != null) {
            return _downloadDone!!
        }
        _downloadDone = materialIcon(name = "Outlined.DownloadDone") {
            materialPath {
                moveTo(5.0f, 18.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(2.0f)
                lineTo(5.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(9.6f, 15.3f)
                lineTo(5.0f, 10.7f)
                lineToRelative(2.0f, -1.9f)
                lineToRelative(2.6f, 2.6f)
                lineTo(17.0f, 4.0f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(-9.4f, 9.3f)
                close()
            }
        }
        return _downloadDone!!
    }

private var _downloadDone: ImageVector? = null
