/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Hiking: ImageVector
    get() {
        if (_hiking != null) {
            return _hiking!!
        }
        _hiking = materialIcon(name = "Outlined.Hiking") {
            materialPath {
                moveTo(13.5f, 5.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(12.4f, 5.5f, 13.5f, 5.5f)
                close()
                moveTo(17.5f, 10.78f)
                curveToRelative(-1.23f, -0.37f, -2.22f, -1.17f, -2.8f, -2.18f)
                lineToRelative(-1.0f, -1.6f)
                curveToRelative(-0.41f, -0.65f, -1.11f, -1.0f, -1.84f, -1.0f)
                curveToRelative(-0.78f, 0.0f, -1.59f, 0.5f, -1.78f, 1.44f)
                reflectiveCurveTo(7.0f, 23.0f, 7.0f, 23.0f)
                horizontalLineToRelative(2.1f)
                lineToRelative(1.8f, -8.0f)
                lineToRelative(2.1f, 2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.5f)
                lineToRelative(-2.1f, -2.0f)
                lineToRelative(0.6f, -3.0f)
                curveToRelative(1.0f, 1.15f, 2.41f, 2.01f, 4.0f, 2.34f)
                verticalLineTo(23.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(17.5f, 10.78f)
                close()
                moveTo(7.43f, 13.13f)
                lineToRelative(-2.12f, -0.41f)
                curveToRelative(-0.54f, -0.11f, -0.9f, -0.63f, -0.79f, -1.17f)
                lineToRelative(0.76f, -3.93f)
                curveToRelative(0.21f, -1.08f, 1.26f, -1.79f, 2.34f, -1.58f)
                lineToRelative(1.16f, 0.23f)
                lineTo(7.43f, 13.13f)
                close()
            }
        }
        return _hiking!!
    }

private var _hiking: ImageVector? = null
