/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Celebration: ImageVector
    get() {
        if (_celebration != null) {
            return _celebration!!
        }
        _celebration = materialIcon(name = "Rounded.Celebration") {
            materialPath {
                moveTo(3.99f, 21.29f)
                lineToRelative(9.04f, -3.23f)
                curveToRelative(1.38f, -0.49f, 1.78f, -2.26f, 0.74f, -3.3f)
                lineToRelative(-4.53f, -4.53f)
                curveToRelative(-1.04f, -1.04f, -2.8f, -0.64f, -3.3f, 0.74f)
                lineToRelative(-3.23f, 9.04f)
                curveTo(2.43f, 20.81f, 3.19f, 21.57f, 3.99f, 21.29f)
                close()
            }
            materialPath {
                moveTo(15.06f, 12.0f)
                lineToRelative(5.06f, -5.06f)
                curveToRelative(0.49f, -0.49f, 1.28f, -0.49f, 1.77f, 0.0f)
                lineTo(21.95f, 7.0f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(-0.06f, -0.06f)
                curveToRelative(-1.07f, -1.07f, -2.82f, -1.07f, -3.89f, 0.0f)
                lineTo(14.0f, 10.94f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(0.0f, 0.0f)
                curveTo(14.29f, 12.29f, 14.77f, 12.29f, 15.06f, 12.0f)
                close()
            }
            materialPath {
                moveTo(10.06f, 6.88f)
                lineTo(10.0f, 6.94f)
                curveTo(9.71f, 7.23f, 9.71f, 7.71f, 10.0f, 8.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(0.06f, -0.06f)
                curveToRelative(1.07f, -1.07f, 1.07f, -2.82f, 0.0f, -3.89f)
                lineTo(11.07f, 4.0f)
                curveTo(10.77f, 3.7f, 10.29f, 3.7f, 10.0f, 4.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(0.06f, 0.06f)
                curveTo(10.54f, 5.6f, 10.54f, 6.4f, 10.06f, 6.88f)
                close()
            }
            materialPath {
                moveTo(17.06f, 11.88f)
                lineTo(16.0f, 12.94f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(1.06f, -1.06f)
                curveToRelative(0.49f, -0.49f, 1.28f, -0.49f, 1.77f, 0.0f)
                lineToRelative(1.08f, 1.08f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(-1.08f, -1.08f)
                curveTo(19.87f, 10.81f, 18.13f, 10.81f, 17.06f, 11.88f)
                close()
            }
            materialPath {
                moveTo(15.06f, 5.88f)
                lineTo(12.0f, 8.94f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(3.06f, -3.06f)
                curveToRelative(1.07f, -1.07f, 1.07f, -2.82f, 0.0f, -3.89f)
                lineToRelative(-1.06f, -1.06f)
                curveToRelative(-0.29f, -0.29f, -0.77f, -0.29f, -1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(1.06f, 1.06f)
                curveTo(15.54f, 4.6f, 15.54f, 5.4f, 15.06f, 5.88f)
                close()
            }
        }
        return _celebration!!
    }

private var _celebration: ImageVector? = null
