/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Dangerous: ImageVector
    get() {
        if (_dangerous != null) {
            return _dangerous!!
        }
        _dangerous = materialIcon(name = "Rounded.Dangerous") {
            materialPath {
                moveTo(14.9f, 3.0f)
                horizontalLineTo(9.1f)
                curveTo(8.57f, 3.0f, 8.06f, 3.21f, 7.68f, 3.59f)
                lineToRelative(-4.1f, 4.1f)
                curveTo(3.21f, 8.06f, 3.0f, 8.57f, 3.0f, 9.1f)
                verticalLineToRelative(5.8f)
                curveToRelative(0.0f, 0.53f, 0.21f, 1.04f, 0.59f, 1.41f)
                lineToRelative(4.1f, 4.1f)
                curveTo(8.06f, 20.79f, 8.57f, 21.0f, 9.1f, 21.0f)
                horizontalLineToRelative(5.8f)
                curveToRelative(0.53f, 0.0f, 1.04f, -0.21f, 1.41f, -0.59f)
                lineToRelative(4.1f, -4.1f)
                curveTo(20.79f, 15.94f, 21.0f, 15.43f, 21.0f, 14.9f)
                verticalLineTo(9.1f)
                curveToRelative(0.0f, -0.53f, -0.21f, -1.04f, -0.59f, -1.41f)
                lineToRelative(-4.1f, -4.1f)
                curveTo(15.94f, 3.21f, 15.43f, 3.0f, 14.9f, 3.0f)
                close()
                moveTo(15.54f, 15.54f)
                lineTo(15.54f, 15.54f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineTo(12.0f, 13.41f)
                lineToRelative(-2.12f, 2.12f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(10.59f, 12.0f)
                lineTo(8.46f, 9.88f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineTo(12.0f, 10.59f)
                lineToRelative(2.12f, -2.12f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(13.41f, 12.0f)
                lineToRelative(2.12f, 2.12f)
                curveTo(15.93f, 14.51f, 15.93f, 15.15f, 15.54f, 15.54f)
                close()
            }
        }
        return _dangerous!!
    }

private var _dangerous: ImageVector? = null
