/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Dining: ImageVector
    get() {
        if (_dining != null) {
            return _dining!!
        }
        _dining = materialIcon(name = "Rounded.Dining") {
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(11.0f, 10.3f)
                curveToRelative(0.0f, 0.93f, -0.64f, 1.71f, -1.5f, 1.93f)
                verticalLineToRelative(6.02f)
                curveTo(9.5f, 18.66f, 9.16f, 19.0f, 8.75f, 19.0f)
                horizontalLineToRelative(0.0f)
                curveTo(8.34f, 19.0f, 8.0f, 18.66f, 8.0f, 18.25f)
                verticalLineToRelative(-6.02f)
                curveToRelative(-0.86f, -0.22f, -1.5f, -1.0f, -1.5f, -1.93f)
                verticalLineTo(6.5f)
                curveTo(6.5f, 6.22f, 6.72f, 6.0f, 7.0f, 6.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(0.75f)
                verticalLineTo(6.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(10.0f)
                verticalLineTo(6.5f)
                curveTo(10.0f, 6.22f, 10.23f, 6.0f, 10.5f, 6.0f)
                curveTo(10.78f, 6.0f, 11.0f, 6.22f, 11.0f, 6.5f)
                verticalLineTo(10.3f)
                close()
                moveTo(15.58f, 12.59f)
                lineToRelative(-0.08f, 0.03f)
                verticalLineToRelative(5.63f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(14.34f, 19.0f, 14.0f, 18.66f, 14.0f, 18.25f)
                verticalLineToRelative(-5.63f)
                lineToRelative(-0.08f, -0.04f)
                curveToRelative(-0.97f, -0.47f, -1.67f, -1.7f, -1.67f, -3.18f)
                curveToRelative(0.0f, -1.88f, 1.13f, -3.4f, 2.5f, -3.4f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.53f, 2.5f, 3.41f)
                curveTo(17.25f, 10.89f, 16.55f, 12.12f, 15.58f, 12.59f)
                close()
            }
        }
        return _dining!!
    }

private var _dining: ImageVector? = null
