/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalCellularConnectedNoInternet0Bar: ImageVector
    get() {
        if (_signalCellularConnectedNoInternet0Bar != null) {
            return _signalCellularConnectedNoInternet0Bar!!
        }
        _signalCellularConnectedNoInternet0Bar = materialIcon(name =
                "Rounded.SignalCellularConnectedNoInternet0Bar") {
            materialPath {
                moveTo(21.0f, 18.0f)
                lineTo(21.0f, 18.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(6.0f)
                curveTo(20.0f, 17.55f, 20.45f, 18.0f, 21.0f, 18.0f)
                close()
                moveTo(21.0f, 22.0f)
                lineTo(21.0f, 22.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(20.0f, 21.55f, 20.45f, 22.0f, 21.0f, 22.0f)
                close()
                moveTo(18.0f, 20.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.0f)
                lineTo(22.0f, 2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.83f)
                lineTo(6.83f, 20.0f)
                horizontalLineTo(18.0f)
                close()
            }
        }
        return _signalCellularConnectedNoInternet0Bar!!
    }

private var _signalCellularConnectedNoInternet0Bar: ImageVector? = null
