/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ClosedCaptionDisabled: ImageVector
    get() {
        if (_closedCaptionDisabled != null) {
            return _closedCaptionDisabled!!
        }
        _closedCaptionDisabled = materialIcon(name = "Sharp.ClosedCaptionDisabled") {
            materialPath {
                moveTo(6.83f, 4.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(14.17f)
                lineTo(17.83f, 15.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-0.17f)
                lineToRelative(-1.83f, -1.83f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(1.17f)
                lineTo(6.83f, 4.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineTo(17.17f, 20.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(5.83f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(11.0f, 13.83f)
                lineTo(10.17f, 13.0f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(0.17f)
                lineTo(6.17f, 9.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(13.83f)
                close()
            }
        }
        return _closedCaptionDisabled!!
    }

private var _closedCaptionDisabled: ImageVector? = null
