/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.East: ImageVector
    get() {
        if (_east != null) {
            return _east!!
        }
        _east = materialIcon(name = "Sharp.East") {
            materialPath {
                moveTo(15.0f, 5.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(18.17f, 11.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(16.17f)
                lineToRelative(-4.59f, 4.59f)
                lineTo(15.0f, 19.0f)
                lineToRelative(7.0f, -7.0f)
                lineTo(15.0f, 5.0f)
                close()
            }
        }
        return _east!!
    }

private var _east: ImageVector? = null
