/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Bungalow: ImageVector
    get() {
        if (_bungalow != null) {
            return _bungalow!!
        }
        _bungalow = materialIcon(name = "TwoTone.Bungalow") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 6.78f)
                lineToRelative(-3.0f, 4.8f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.42f)
                lineTo(12.0f, 6.78f)
                close()
                moveTo(13.0f, 14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(18.1f, 16.56f)
                lineTo(17.0f, 14.79f)
                verticalLineTo(21.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-6.2f)
                lineToRelative(-1.1f, 1.76f)
                lineTo(4.2f, 15.5f)
                lineTo(12.0f, 3.0f)
                lineToRelative(7.8f, 12.5f)
                lineTo(18.1f, 16.56f)
                close()
                moveTo(15.0f, 11.59f)
                lineToRelative(-3.0f, -4.8f)
                lineToRelative(-3.0f, 4.8f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.59f)
                close()
            }
        }
        return _bungalow!!
    }

private var _bungalow: ImageVector? = null
