/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsCricket: ImageVector
    get() {
        if (_sportsCricket != null) {
            return _sportsCricket!!
        }
        _sportsCricket = materialIcon(name = "TwoTone.SportsCricket") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.4141f, 7.8394f)
                lineToRelative(1.4213f, -1.4213f)
                lineToRelative(7.0851f, 7.0851f)
                lineToRelative(-1.4213f, 1.4213f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.5f, 5.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(15.04f, 12.79f)
                lineToRelative(-8.5f, -8.5f)
                curveTo(6.35f, 4.1f, 6.09f, 4.0f, 5.83f, 4.0f)
                reflectiveCurveTo(5.32f, 4.1f, 5.13f, 4.29f)
                lineTo(2.29f, 7.13f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.03f, 0.0f, 1.42f)
                lineToRelative(8.5f, 8.5f)
                curveToRelative(0.2f, 0.2f, 0.45f, 0.29f, 0.71f, 0.29f)
                curveToRelative(0.26f, 0.0f, 0.51f, -0.1f, 0.71f, -0.29f)
                lineToRelative(2.83f, -2.83f)
                curveTo(15.43f, 13.82f, 15.43f, 13.18f, 15.04f, 12.79f)
                close()
                moveTo(11.5f, 14.92f)
                lineTo(4.41f, 7.83f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(7.09f, 7.09f)
                lineTo(11.5f, 14.92f)
                close()
            }
            materialPath {
                moveTo(14.3412f, 17.7562f)
                lineToRelative(1.4142f, -1.4142f)
                lineToRelative(4.2426f, 4.2426f)
                lineToRelative(-1.4142f, 1.4142f)
                close()
            }
            materialPath {
                moveTo(18.5f, 2.0f)
                curveTo(16.57f, 2.0f, 15.0f, 3.57f, 15.0f, 5.5f)
                curveTo(15.0f, 7.43f, 16.57f, 9.0f, 18.5f, 9.0f)
                reflectiveCurveTo(22.0f, 7.43f, 22.0f, 5.5f)
                curveTo(22.0f, 3.57f, 20.43f, 2.0f, 18.5f, 2.0f)
                close()
                moveTo(18.5f, 7.0f)
                curveTo(17.67f, 7.0f, 17.0f, 6.33f, 17.0f, 5.5f)
                reflectiveCurveTo(17.67f, 4.0f, 18.5f, 4.0f)
                reflectiveCurveTo(20.0f, 4.67f, 20.0f, 5.5f)
                reflectiveCurveTo(19.33f, 7.0f, 18.5f, 7.0f)
                close()
            }
        }
        return _sportsCricket!!
    }

private var _sportsCricket: ImageVector? = null
