/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone._1xMobiledata: ImageVector
    get() {
        if (__1xMobiledata != null) {
            return __1xMobiledata!!
        }
        __1xMobiledata = materialIcon(name = "TwoTone._1xMobiledata") {
            materialPath {
                moveTo(4.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(10.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(15.83f, 11.72f)
                lineTo(18.66f, 7.0f)
                horizontalLineToRelative(-2.33f)
                lineToRelative(-1.66f, 2.77f)
                lineTo(13.0f, 7.0f)
                horizontalLineToRelative(-2.33f)
                lineToRelative(2.83f, 4.72f)
                lineTo(10.33f, 17.0f)
                horizontalLineToRelative(2.33f)
                lineToRelative(2.0f, -3.34f)
                lineToRelative(2.0f, 3.34f)
                horizontalLineTo(19.0f)
                lineTo(15.83f, 11.72f)
                close()
            }
        }
        return __1xMobiledata!!
    }

private var __1xMobiledata: ImageVector? = null
