/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AssuredWorkload: ImageVector
    get() {
        if (_assuredWorkload != null) {
            return _assuredWorkload!!
        }
        _assuredWorkload = materialIcon(name = "Filled.AssuredWorkload") {
            materialPath {
                moveTo(5.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 6.0f)
                lineToRelative(-10.0f, -5.0f)
                lineToRelative(-10.0f, 5.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(20.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 19.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(12.4f)
                curveToRelative(-0.21f, -0.64f, -0.32f, -1.31f, -0.36f, -2.0f)
                horizontalLineTo(2.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 12.26f)
                lineToRelative(0.0f, -2.26f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 3.26f)
                close()
            }
            materialPath {
                moveTo(20.0f, 14.0f)
                lineToRelative(-4.0f, 2.0f)
                verticalLineToRelative(2.55f)
                curveToRelative(0.0f, 2.52f, 1.71f, 4.88f, 4.0f, 5.45f)
                curveToRelative(2.29f, -0.57f, 4.0f, -2.93f, 4.0f, -5.45f)
                verticalLineTo(16.0f)
                lineTo(20.0f, 14.0f)
                close()
                moveTo(19.28f, 21.0f)
                lineToRelative(-2.03f, -2.03f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(0.97f, 0.97f)
                lineToRelative(2.41f, -2.38f)
                lineToRelative(1.06f, 1.06f)
                lineTo(19.28f, 21.0f)
                close()
            }
        }
        return _assuredWorkload!!
    }

private var _assuredWorkload: ImageVector? = null
