/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoiseAware: ImageVector
    get() {
        if (_noiseAware != null) {
            return _noiseAware!!
        }
        _noiseAware = materialIcon(name = "Filled.NoiseAware") {
            materialPath {
                moveTo(4.07f, 13.0f)
                horizontalLineTo(2.05f)
                curveToRelative(0.2f, 2.01f, 1.0f, 3.84f, 2.21f, 5.33f)
                lineToRelative(1.43f, -1.43f)
                curveTo(4.83f, 15.79f, 4.25f, 14.46f, 4.07f, 13.0f)
                close()
            }
            materialPath {
                moveTo(5.69f, 7.1f)
                lineTo(4.26f, 5.67f)
                curveTo(3.05f, 7.16f, 2.25f, 8.99f, 2.05f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveTo(4.25f, 9.54f, 4.83f, 8.21f, 5.69f, 7.1f)
                close()
            }
            materialPath {
                moveTo(11.0f, 4.07f)
                verticalLineTo(2.05f)
                curveToRelative(-2.01f, 0.2f, -3.84f, 1.0f, -5.33f, 2.21f)
                lineTo(7.1f, 5.69f)
                curveTo(8.21f, 4.83f, 9.54f, 4.25f, 11.0f, 4.07f)
                close()
            }
            materialPath {
                moveTo(18.33f, 4.26f)
                curveTo(16.84f, 3.05f, 15.01f, 2.25f, 13.0f, 2.05f)
                verticalLineToRelative(2.02f)
                curveToRelative(1.46f, 0.18f, 2.79f, 0.76f, 3.9f, 1.62f)
                lineTo(18.33f, 4.26f)
                close()
            }
            materialPath {
                moveTo(18.31f, 16.9f)
                lineToRelative(1.43f, 1.43f)
                curveToRelative(1.21f, -1.48f, 2.01f, -3.32f, 2.21f, -5.33f)
                horizontalLineToRelative(-2.02f)
                curveTo(19.75f, 14.46f, 19.17f, 15.79f, 18.31f, 16.9f)
                close()
            }
            materialPath {
                moveTo(19.93f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(-0.2f, -2.01f, -1.0f, -3.84f, -2.21f, -5.33f)
                lineTo(18.31f, 7.1f)
                curveTo(19.17f, 8.21f, 19.75f, 9.54f, 19.93f, 11.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 19.93f)
                verticalLineToRelative(2.02f)
                curveToRelative(2.01f, -0.2f, 3.84f, -1.0f, 5.33f, -2.21f)
                lineToRelative(-1.43f, -1.43f)
                curveTo(15.79f, 19.17f, 14.46f, 19.75f, 13.0f, 19.93f)
                close()
            }
            materialPath {
                moveTo(5.67f, 19.74f)
                curveToRelative(1.48f, 1.21f, 3.32f, 2.01f, 5.33f, 2.21f)
                verticalLineToRelative(-2.02f)
                curveToRelative(-1.46f, -0.18f, -2.79f, -0.76f, -3.9f, -1.62f)
                lineTo(5.67f, 19.74f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-5.0f, 0.0f)
                arcToRelative(5.0f, 5.0f, 0.0f, true, true, 10.0f, 0.0f)
                arcToRelative(5.0f, 5.0f, 0.0f, true, true, -10.0f, 0.0f)
            }
        }
        return _noiseAware!!
    }

private var _noiseAware: ImageVector? = null
