/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ScubaDiving: ImageVector
    get() {
        if (_scubaDiving != null) {
            return _scubaDiving!!
        }
        _scubaDiving = materialIcon(name = "Filled.ScubaDiving") {
            materialPath {
                moveTo(1.0f, 13.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(1.0f, 14.1f, 1.0f, 13.0f)
                close()
                moveTo(8.89f, 10.11f)
                lineToRelative(4.53f, -1.21f)
                lineTo(12.64f, 6.0f)
                lineTo(8.11f, 7.21f)
                curveToRelative(-0.8f, 0.21f, -1.28f, 1.04f, -1.06f, 1.84f)
                lineToRelative(0.0f, 0.0f)
                curveTo(7.27f, 9.85f, 8.09f, 10.33f, 8.89f, 10.11f)
                close()
                moveTo(20.5f, 5.9f)
                lineTo(23.0f, 3.0f)
                lineToRelative(-1.0f, -1.0f)
                lineToRelative(-3.0f, 3.0f)
                lineToRelative(-2.0f, 4.0f)
                lineToRelative(-9.48f, 2.87f)
                curveToRelative(-0.82f, 0.2f, -1.39f, 0.89f, -1.5f, 1.68f)
                lineTo(5.24f, 18.0f)
                lineTo(2.4f, 21.8f)
                lineTo(4.0f, 23.0f)
                lineToRelative(3.0f, -4.0f)
                lineToRelative(1.14f, -3.14f)
                lineTo(14.0f, 14.0f)
                lineToRelative(5.0f, -3.5f)
                lineTo(20.5f, 5.9f)
                close()
            }
        }
        return _scubaDiving!!
    }

private var _scubaDiving: ImageVector? = null
