/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FormatColorReset: ImageVector
    get() {
        if (_formatColorReset != null) {
            return _formatColorReset!!
        }
        _formatColorReset = materialIcon(name = "Outlined.FormatColorReset") {
            materialPath {
                moveTo(12.0f, 6.36f)
                curveToRelative(1.53f, 2.0f, 3.08f, 4.43f, 3.71f, 6.24f)
                lineToRelative(2.23f, 2.23f)
                curveToRelative(0.03f, -0.27f, 0.06f, -0.55f, 0.06f, -0.83f)
                curveToRelative(0.0f, -3.98f, -6.0f, -10.8f, -6.0f, -10.8f)
                reflectiveCurveToRelative(-1.18f, 1.35f, -2.5f, 3.19f)
                lineToRelative(1.44f, 1.44f)
                curveToRelative(0.34f, -0.51f, 0.7f, -1.0f, 1.06f, -1.47f)
                close()
                moveTo(5.41f, 5.14f)
                lineTo(4.0f, 6.55f)
                lineToRelative(3.32f, 3.32f)
                curveTo(6.55f, 11.33f, 6.0f, 12.79f, 6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(1.52f, 0.0f, 2.9f, -0.57f, 3.95f, -1.5f)
                lineToRelative(2.63f, 2.63f)
                lineTo(20.0f, 19.72f)
                lineTo(5.41f, 5.14f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -0.69f, 0.32f, -1.62f, 0.81f, -2.64f)
                lineToRelative(5.72f, 5.72f)
                curveToRelative(-0.7f, 0.56f, -1.57f, 0.92f, -2.53f, 0.92f)
                close()
            }
        }
        return _formatColorReset!!
    }

private var _formatColorReset: ImageVector? = null
