/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Hive: ImageVector
    get() {
        if (_hive != null) {
            return _hive!!
        }
        _hive = materialIcon(name = "Outlined.Hive") {
            materialPath {
                moveTo(21.5f, 9.0f)
                lineToRelative(-2.25f, -4.0f)
                horizontalLineToRelative(-3.31f)
                lineToRelative(-1.69f, -3.0f)
                horizontalLineToRelative(-4.5f)
                lineTo(8.06f, 5.0f)
                horizontalLineTo(4.75f)
                lineTo(2.5f, 9.0f)
                lineToRelative(1.69f, 3.0f)
                lineTo(2.5f, 15.0f)
                lineToRelative(2.25f, 4.0f)
                horizontalLineToRelative(3.31f)
                lineToRelative(1.69f, 3.0f)
                horizontalLineToRelative(4.5f)
                lineToRelative(1.69f, -3.0f)
                horizontalLineToRelative(3.31f)
                lineToRelative(2.25f, -4.0f)
                lineToRelative(-1.69f, -3.0f)
                lineTo(21.5f, 9.0f)
                close()
                moveTo(19.21f, 9.0f)
                lineToRelative(-1.12f, 2.0f)
                horizontalLineToRelative(-2.14f)
                lineToRelative(-1.12f, -2.0f)
                lineToRelative(1.12f, -2.0f)
                horizontalLineToRelative(2.14f)
                lineTo(19.21f, 9.0f)
                close()
                moveTo(10.94f, 14.0f)
                lineToRelative(-1.12f, -2.0f)
                lineToRelative(1.12f, -2.0f)
                horizontalLineToRelative(2.12f)
                lineToRelative(1.12f, 2.0f)
                lineToRelative(-1.12f, 2.0f)
                horizontalLineTo(10.94f)
                close()
                moveTo(13.08f, 4.0f)
                lineToRelative(1.12f, 1.98f)
                lineTo(13.06f, 8.0f)
                horizontalLineToRelative(-2.12f)
                lineTo(9.8f, 5.98f)
                lineTo(10.92f, 4.0f)
                horizontalLineTo(13.08f)
                close()
                moveTo(5.92f, 7.0f)
                horizontalLineToRelative(2.14f)
                lineToRelative(1.12f, 2.0f)
                lineToRelative(-1.12f, 2.0f)
                horizontalLineTo(5.92f)
                lineTo(4.79f, 9.0f)
                lineTo(5.92f, 7.0f)
                close()
                moveTo(4.79f, 15.0f)
                lineToRelative(1.12f, -2.0f)
                horizontalLineToRelative(2.14f)
                lineToRelative(1.12f, 2.0f)
                lineToRelative(-1.12f, 2.0f)
                horizontalLineTo(5.92f)
                lineTo(4.79f, 15.0f)
                close()
                moveTo(10.92f, 20.0f)
                lineTo(9.8f, 18.02f)
                lineTo(10.94f, 16.0f)
                horizontalLineToRelative(2.12f)
                lineToRelative(1.13f, 2.02f)
                lineTo(13.08f, 20.0f)
                horizontalLineTo(10.92f)
                close()
                moveTo(18.08f, 17.0f)
                horizontalLineToRelative(-2.14f)
                lineToRelative(-1.12f, -2.0f)
                lineToRelative(1.12f, -2.0f)
                horizontalLineToRelative(2.14f)
                lineToRelative(1.12f, 2.0f)
                lineTo(18.08f, 17.0f)
                close()
            }
        }
        return _hive!!
    }

private var _hive: ImageVector? = null
