/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MicExternalOff: ImageVector
    get() {
        if (_micExternalOff != null) {
            return _micExternalOff!!
        }
        _micExternalOff = materialIcon(name = "Outlined.MicExternalOff") {
            materialPath {
                moveTo(10.0f, 5.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                curveTo(6.38f, 2.0f, 5.81f, 2.19f, 5.33f, 2.5f)
                lineToRelative(4.15f, 4.15f)
                curveTo(9.8f, 6.18f, 10.0f, 5.61f, 10.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(9.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveToRelative(-4.0f, 1.79f, -4.0f, 4.0f)
                verticalLineToRelative(3.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(6.0f)
                close()
            }
            materialPath {
                moveTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineTo(5.17f, 8.0f)
                horizontalLineTo(4.0f)
                lineToRelative(1.0f, 10.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(6.49f, 6.49f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                close()
                moveTo(7.19f, 16.0f)
                horizontalLineTo(6.81f)
                lineToRelative(-0.6f, -6.0f)
                horizontalLineToRelative(0.96f)
                lineToRelative(0.56f, 0.56f)
                lineTo(7.19f, 16.0f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(0.56f, -5.61f)
                lineTo(12.0f, 14.83f)
                verticalLineTo(18.0f)
                close()
            }
        }
        return _micExternalOff!!
    }

private var _micExternalOff: ImageVector? = null
