/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PlusOne: ImageVector
    get() {
        if (_plusOne != null) {
            return _plusOne!!
        }
        _plusOne = materialIcon(name = "Outlined.PlusOne") {
            materialPath {
                moveTo(10.0f, 8.0f)
                lineTo(8.0f, 8.0f)
                verticalLineToRelative(4.0f)
                lineTo(4.0f, 12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(10.0f, 8.0f)
                close()
                moveTo(14.5f, 6.08f)
                lineTo(14.5f, 7.9f)
                lineToRelative(2.5f, -0.5f)
                lineTo(17.0f, 18.0f)
                horizontalLineToRelative(2.0f)
                lineTo(19.0f, 5.0f)
                lineToRelative(-4.5f, 1.08f)
                close()
            }
        }
        return _plusOne!!
    }

private var _plusOne: ImageVector? = null
