/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SpeakerNotesOff: ImageVector
    get() {
        if (_speakerNotesOff != null) {
            return _speakerNotesOff!!
        }
        _speakerNotesOff = materialIcon(name = "Outlined.SpeakerNotesOff") {
            materialPath {
                moveTo(20.0f, 4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-1.34f)
                lineToRelative(1.91f, 1.91f)
                curveTo(21.39f, 17.66f, 22.0f, 16.9f, 22.0f, 16.0f)
                lineTo(22.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(4.66f, 2.0f)
                lineToRelative(2.0f, 2.0f)
                lineTo(20.0f, 4.0f)
                close()
                moveTo(6.0f, 12.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                lineTo(6.0f, 14.0f)
                close()
                moveTo(18.0f, 9.0f)
                horizontalLineToRelative(-6.34f)
                lineToRelative(2.0f, 2.0f)
                lineTo(18.0f, 11.0f)
                close()
                moveTo(18.0f, 6.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(1.34f)
                lineToRelative(0.66f, 0.66f)
                lineTo(18.0f, 8.0f)
                close()
                moveTo(1.41f, 1.59f)
                lineTo(0.0f, 3.0f)
                lineToRelative(2.01f, 2.01f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(9.0f)
                lineToRelative(5.73f, 5.73f)
                lineToRelative(1.41f, -1.41f)
                lineTo(1.41f, 1.59f)
                close()
                moveTo(5.17f, 16.0f)
                lineTo(4.0f, 17.17f)
                lineTo(4.0f, 7.0f)
                lineToRelative(2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(5.0f, 5.0f)
                lineTo(5.17f, 16.0f)
                close()
            }
        }
        return _speakerNotesOff!!
    }

private var _speakerNotesOff: ImageVector? = null
