/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ViewComfy: ImageVector
    get() {
        if (_viewComfy != null) {
            return _viewComfy!!
        }
        _viewComfy = materialIcon(name = "Outlined.ViewComfy") {
            materialPath {
                moveTo(3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(19.0f)
                lineTo(22.0f, 5.0f)
                lineTo(3.0f, 5.0f)
                close()
                moveTo(20.0f, 9.0f)
                horizontalLineToRelative(-2.25f)
                lineTo(17.75f, 7.0f)
                lineTo(20.0f, 7.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(9.25f, 11.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                lineTo(9.25f, 13.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(7.25f, 13.0f)
                lineTo(5.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(11.5f, 9.0f)
                lineTo(9.25f, 9.0f)
                lineTo(9.25f, 7.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(13.5f, 7.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                lineTo(13.5f, 9.0f)
                lineTo(13.5f, 7.0f)
                close()
                moveTo(11.5f, 15.0f)
                verticalLineToRelative(2.0f)
                lineTo(9.25f, 17.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.25f)
                close()
                moveTo(13.5f, 15.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                lineTo(13.5f, 17.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(13.5f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                lineTo(13.5f, 13.0f)
                close()
                moveTo(17.75f, 11.0f)
                lineTo(20.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.25f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(7.25f, 7.0f)
                verticalLineToRelative(2.0f)
                lineTo(5.0f, 9.0f)
                lineTo(5.0f, 7.0f)
                horizontalLineToRelative(2.25f)
                close()
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(2.25f)
                verticalLineToRelative(2.0f)
                lineTo(5.0f, 17.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(17.75f, 17.0f)
                verticalLineToRelative(-2.0f)
                lineTo(20.0f, 15.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.25f)
                close()
            }
        }
        return _viewComfy!!
    }

private var _viewComfy: ImageVector? = null
