/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LayersClear: ImageVector
    get() {
        if (_layersClear != null) {
            return _layersClear!!
        }
        _layersClear = materialIcon(name = "Rounded.LayersClear") {
            materialPath {
                moveTo(19.99f, 9.79f)
                curveToRelative(0.51f, -0.4f, 0.51f, -1.18f, 0.0f, -1.58f)
                lineToRelative(-6.76f, -5.26f)
                curveToRelative(-0.72f, -0.56f, -1.73f, -0.56f, -2.46f, 0.0f)
                lineTo(9.41f, 4.02f)
                lineToRelative(7.88f, 7.88f)
                lineToRelative(2.7f, -2.11f)
                close()
                moveTo(19.99f, 13.28f)
                lineToRelative(-0.01f, -0.01f)
                curveToRelative(-0.36f, -0.28f, -0.86f, -0.28f, -1.22f, 0.0f)
                lineToRelative(-0.05f, 0.04f)
                lineToRelative(1.4f, 1.4f)
                curveToRelative(0.37f, -0.41f, 0.34f, -1.07f, -0.12f, -1.43f)
                close()
                moveTo(21.44f, 18.88f)
                lineTo(4.12f, 1.56f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.52f, 3.52f)
                lineToRelative(-2.22f, 1.72f)
                curveToRelative(-0.51f, 0.4f, -0.51f, 1.18f, 0.0f, 1.58f)
                lineToRelative(6.76f, 5.26f)
                curveToRelative(0.72f, 0.56f, 1.73f, 0.56f, 2.46f, 0.0f)
                lineToRelative(0.87f, -0.68f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(-2.92f, 2.27f)
                curveToRelative(-0.36f, 0.28f, -0.87f, 0.28f, -1.23f, 0.0f)
                lineToRelative(-6.15f, -4.78f)
                curveToRelative(-0.36f, -0.28f, -0.86f, -0.28f, -1.22f, 0.0f)
                curveToRelative(-0.51f, 0.4f, -0.51f, 1.17f, 0.0f, 1.57f)
                lineToRelative(6.76f, 5.26f)
                curveToRelative(0.72f, 0.56f, 1.73f, 0.56f, 2.46f, 0.0f)
                lineToRelative(3.72f, -2.89f)
                lineToRelative(3.07f, 3.07f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.41f, -0.39f, 0.41f, -1.02f, 0.02f, -1.41f)
                close()
            }
        }
        return _layersClear!!
    }

private var _layersClear: ImageVector? = null
