/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalActivity: ImageVector
    get() {
        if (_localActivity != null) {
            return _localActivity!!
        }
        _localActivity = materialIcon(name = "Rounded.LocalActivity") {
            materialPath {
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, -0.76f, 0.43f, -1.42f, 1.06f, -1.76f)
                curveToRelative(0.6f, -0.33f, 0.94f, -1.01f, 0.94f, -1.7f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -1.99f, 0.89f, -1.99f, 1.99f)
                verticalLineToRelative(2.55f)
                curveToRelative(0.0f, 0.69f, 0.33f, 1.37f, 0.94f, 1.69f)
                curveTo(3.58f, 10.58f, 4.0f, 11.24f, 4.0f, 12.0f)
                reflectiveCurveToRelative(-0.43f, 1.43f, -1.06f, 1.76f)
                curveToRelative(-0.6f, 0.33f, -0.94f, 1.01f, -0.94f, 1.7f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-2.54f)
                curveToRelative(0.0f, -0.69f, -0.34f, -1.37f, -0.94f, -1.7f)
                curveToRelative(-0.63f, -0.34f, -1.06f, -1.0f, -1.06f, -1.76f)
                close()
                moveTo(14.5f, 16.1f)
                lineTo(12.0f, 14.5f)
                lineToRelative(-2.5f, 1.61f)
                curveToRelative(-0.38f, 0.24f, -0.87f, -0.11f, -0.75f, -0.55f)
                lineToRelative(0.75f, -2.88f)
                lineToRelative(-2.3f, -1.88f)
                curveToRelative(-0.35f, -0.29f, -0.17f, -0.86f, 0.29f, -0.89f)
                lineToRelative(2.96f, -0.17f)
                lineToRelative(1.08f, -2.75f)
                curveToRelative(0.17f, -0.42f, 0.77f, -0.42f, 0.93f, 0.0f)
                lineToRelative(1.08f, 2.76f)
                lineToRelative(2.96f, 0.17f)
                curveToRelative(0.45f, 0.03f, 0.64f, 0.6f, 0.29f, 0.89f)
                lineToRelative(-2.3f, 1.88f)
                lineToRelative(0.76f, 2.86f)
                curveToRelative(0.12f, 0.45f, -0.37f, 0.8f, -0.75f, 0.55f)
                close()
            }
        }
        return _localActivity!!
    }

private var _localActivity: ImageVector? = null
