/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Motorcycle: ImageVector
    get() {
        if (_motorcycle != null) {
            return _motorcycle!!
        }
        _motorcycle = materialIcon(name = "Rounded.Motorcycle") {
            materialPath {
                moveTo(19.44f, 9.03f)
                lineTo(17.31f, 6.9f)
                lineToRelative(-1.6f, -1.6f)
                curveToRelative(-0.19f, -0.19f, -0.45f, -0.3f, -0.71f, -0.3f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.59f)
                lineToRelative(2.0f, 2.0f)
                lineTo(5.0f, 9.0f)
                curveToRelative(-2.8f, 0.0f, -5.0f, 2.2f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.2f, 5.0f, 5.0f, 5.0f)
                curveToRelative(2.46f, 0.0f, 4.45f, -1.69f, 4.9f, -4.0f)
                horizontalLineToRelative(0.82f)
                curveToRelative(0.53f, 0.0f, 1.04f, -0.21f, 1.41f, -0.59f)
                lineToRelative(2.18f, -2.18f)
                curveToRelative(-0.2f, 0.54f, -0.31f, 1.14f, -0.31f, 1.77f)
                curveToRelative(0.0f, 2.8f, 2.2f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.2f, 5.0f, -5.0f)
                curveToRelative(0.0f, -2.65f, -1.97f, -4.77f, -4.56f, -4.97f)
                close()
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(2.82f)
                curveTo(7.4f, 16.15f, 6.28f, 17.0f, 5.0f, 17.0f)
                curveToRelative(-1.63f, 0.0f, -3.0f, -1.37f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.37f, -3.0f, 3.0f, -3.0f)
                curveToRelative(1.28f, 0.0f, 2.4f, 0.85f, 2.82f, 2.0f)
                lineTo(5.0f, 13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.34f, 3.0f, -3.0f, 3.0f)
                close()
            }
        }
        return _motorcycle!!
    }

private var _motorcycle: ImageVector? = null
