/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Pool: ImageVector
    get() {
        if (_pool != null) {
            return _pool!!
        }
        _pool = materialIcon(name = "Rounded.Pool") {
            materialPath {
                moveTo(6.11f, 5.56f)
                curveTo(7.3f, 5.7f, 8.14f, 6.14f, 9.0f, 7.0f)
                lineToRelative(1.0f, 1.0f)
                lineToRelative(-3.25f, 3.25f)
                curveToRelative(0.31f, 0.12f, 0.56f, 0.27f, 0.77f, 0.39f)
                curveToRelative(0.37f, 0.23f, 0.59f, 0.36f, 1.15f, 0.36f)
                reflectiveCurveToRelative(0.78f, -0.13f, 1.15f, -0.36f)
                curveToRelative(0.46f, -0.27f, 1.08f, -0.64f, 2.19f, -0.64f)
                reflectiveCurveToRelative(1.73f, 0.37f, 2.18f, 0.64f)
                curveToRelative(0.37f, 0.22f, 0.6f, 0.36f, 1.15f, 0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, -0.13f, 1.15f, -0.36f)
                curveToRelative(0.12f, -0.07f, 0.26f, -0.15f, 0.41f, -0.23f)
                lineTo(10.48f, 5.0f)
                curveTo(9.22f, 3.74f, 8.04f, 3.2f, 6.3f, 3.05f)
                curveTo(5.6f, 2.99f, 5.0f, 3.56f, 5.0f, 4.26f)
                verticalLineToRelative(0.09f)
                curveToRelative(0.0f, 0.63f, 0.49f, 1.13f, 1.11f, 1.21f)
                close()
                moveTo(21.35f, 18.91f)
                curveToRelative(-0.17f, -0.06f, -0.32f, -0.15f, -0.5f, -0.27f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.18f, 0.64f)
                curveToRelative(-0.37f, 0.23f, -0.6f, 0.36f, -1.15f, 0.36f)
                curveToRelative(-0.55f, 0.0f, -0.78f, -0.14f, -1.15f, -0.36f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.19f, 0.64f)
                curveToRelative(-0.37f, 0.23f, -0.59f, 0.36f, -1.15f, 0.36f)
                reflectiveCurveToRelative(-0.78f, -0.13f, -1.15f, -0.36f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.19f, 0.64f)
                curveToRelative(-0.18f, 0.11f, -0.33f, 0.2f, -0.5f, 0.27f)
                curveToRelative(-0.38f, 0.13f, -0.65f, 0.45f, -0.65f, 0.85f)
                verticalLineToRelative(0.12f)
                curveToRelative(0.0f, 0.67f, 0.66f, 1.13f, 1.3f, 0.91f)
                curveToRelative(0.37f, -0.13f, 0.65f, -0.3f, 0.89f, -0.44f)
                curveToRelative(0.37f, -0.22f, 0.6f, -0.35f, 1.15f, -0.35f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.13f, 1.15f, 0.36f)
                curveToRelative(0.45f, 0.27f, 1.07f, 0.64f, 2.18f, 0.64f)
                reflectiveCurveToRelative(1.73f, -0.37f, 2.19f, -0.64f)
                curveToRelative(0.37f, -0.23f, 0.59f, -0.36f, 1.15f, -0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.14f, 1.15f, 0.36f)
                curveToRelative(0.45f, 0.27f, 1.07f, 0.64f, 2.18f, 0.64f)
                reflectiveCurveToRelative(1.72f, -0.37f, 2.18f, -0.64f)
                curveToRelative(0.37f, -0.23f, 0.59f, -0.36f, 1.15f, -0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.14f, 1.15f, 0.36f)
                curveToRelative(0.23f, 0.14f, 0.51f, 0.31f, 0.88f, 0.44f)
                curveToRelative(0.63f, 0.22f, 1.3f, -0.24f, 1.3f, -0.91f)
                verticalLineToRelative(-0.12f)
                curveToRelative(0.0f, -0.41f, -0.27f, -0.73f, -0.65f, -0.86f)
                close()
                moveTo(3.11f, 16.35f)
                curveToRelative(0.47f, -0.13f, 0.81f, -0.33f, 1.09f, -0.49f)
                curveToRelative(0.37f, -0.23f, 0.6f, -0.36f, 1.15f, -0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.14f, 1.15f, 0.36f)
                curveToRelative(0.45f, 0.27f, 1.07f, 0.64f, 2.18f, 0.64f)
                reflectiveCurveToRelative(1.73f, -0.37f, 2.18f, -0.64f)
                curveToRelative(0.37f, -0.23f, 0.59f, -0.36f, 1.15f, -0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.14f, 1.15f, 0.36f)
                curveToRelative(0.45f, 0.27f, 1.07f, 0.64f, 2.18f, 0.64f)
                reflectiveCurveToRelative(1.73f, -0.37f, 2.18f, -0.64f)
                curveToRelative(0.37f, -0.23f, 0.59f, -0.36f, 1.15f, -0.36f)
                curveToRelative(0.55f, 0.0f, 0.78f, 0.14f, 1.15f, 0.36f)
                curveToRelative(0.23f, 0.14f, 0.5f, 0.3f, 0.85f, 0.43f)
                curveToRelative(0.63f, 0.23f, 1.31f, -0.24f, 1.31f, -0.91f)
                verticalLineToRelative(-0.12f)
                curveToRelative(0.0f, -0.4f, -0.27f, -0.72f, -0.64f, -0.86f)
                curveToRelative(-0.17f, -0.06f, -0.32f, -0.15f, -0.51f, -0.26f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.18f, 0.64f)
                curveToRelative(-0.37f, 0.23f, -0.6f, 0.36f, -1.15f, 0.36f)
                reflectiveCurveToRelative(-0.78f, -0.14f, -1.15f, -0.36f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.18f, 0.64f)
                curveToRelative(-0.37f, 0.23f, -0.59f, 0.36f, -1.15f, 0.36f)
                curveToRelative(-0.55f, 0.0f, -0.78f, -0.14f, -1.15f, -0.36f)
                curveToRelative(-0.45f, -0.27f, -1.07f, -0.64f, -2.18f, -0.64f)
                reflectiveCurveToRelative(-1.73f, 0.37f, -2.18f, 0.64f)
                curveToRelative(-0.18f, 0.11f, -0.33f, 0.2f, -0.5f, 0.27f)
                curveToRelative(-0.38f, 0.13f, -0.65f, 0.45f, -0.65f, 0.85f)
                verticalLineToRelative(0.23f)
                curveToRelative(0.0f, 0.58f, 0.55f, 1.02f, 1.11f, 0.86f)
                close()
            }
            materialPath {
                moveTo(16.5f, 5.5f)
                moveToRelative(-2.5f, 0.0f)
                arcToRelative(2.5f, 2.5f, 0.0f, true, true, 5.0f, 0.0f)
                arcToRelative(2.5f, 2.5f, 0.0f, true, true, -5.0f, 0.0f)
            }
        }
        return _pool!!
    }

private var _pool: ImageVector? = null
