/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Atm: ImageVector
    get() {
        if (_atm != null) {
            return _atm!!
        }
        _atm = materialIcon(name = "Sharp.Atm") {
            materialPath {
                moveTo(8.0f, 9.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(2.25f)
                lineTo(10.25f, 15.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.5f)
                lineTo(14.0f, 10.5f)
                lineTo(14.0f, 9.0f)
                lineTo(8.0f, 9.0f)
                close()
                moveTo(7.0f, 9.0f)
                lineTo(2.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(2.0f)
                lineTo(5.5f, 15.0f)
                lineTo(7.0f, 15.0f)
                lineTo(7.0f, 9.0f)
                close()
                moveTo(5.5f, 12.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(2.0f)
                lineTo(5.5f, 12.0f)
                close()
                moveTo(22.0f, 9.0f)
                horizontalLineToRelative(-6.5f)
                verticalLineToRelative(6.0f)
                lineTo(17.0f, 15.0f)
                verticalLineToRelative(-4.5f)
                horizontalLineToRelative(1.0f)
                lineTo(18.0f, 14.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-3.51f)
                horizontalLineToRelative(1.0f)
                lineTo(20.5f, 15.0f)
                lineTo(22.0f, 15.0f)
                lineTo(22.0f, 9.0f)
                close()
            }
        }
        return _atm!!
    }

private var _atm: ImageVector? = null
