/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DataExploration: ImageVector
    get() {
        if (_dataExploration != null) {
            return _dataExploration!!
        }
        _dataExploration = materialIcon(name = "Sharp.DataExploration") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 1.33f, 0.26f, 2.61f, 0.74f, 3.77f)
                lineTo(8.0f, 10.5f)
                lineToRelative(3.3f, 2.78f)
                lineTo(14.58f, 10.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.58f)
                lineTo(11.41f, 16.0f)
                lineToRelative(-3.29f, -2.79f)
                lineToRelative(-4.4f, 4.4f)
                curveTo(5.52f, 20.26f, 8.56f, 22.0f, 12.0f, 22.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(12.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(19.5f, 20.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(20.05f, 20.5f, 19.5f, 20.5f)
                close()
            }
        }
        return _dataExploration!!
    }

private var _dataExploration: ImageVector? = null
