/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FolderOff: ImageVector
    get() {
        if (_folderOff != null) {
            return _folderOff!!
        }
        _folderOff = materialIcon(name = "Sharp.FolderOff") {
            materialPath {
                moveTo(12.0f, 6.0f)
                lineToRelative(-2.0f, -2.0f)
                lineToRelative(-3.17f, 0.0f)
                lineToRelative(15.17f, 15.17f)
                lineToRelative(0.0f, -13.17f)
                close()
            }
            materialPath {
                moveTo(2.1f, 2.1f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.31f, 1.32f)
                lineToRelative(0.0f, 15.17f)
                lineToRelative(15.17f, 0.0f)
                lineToRelative(3.32f, 3.31f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _folderOff!!
    }

private var _folderOff: ImageVector? = null
