/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.InstallMobile: ImageVector
    get() {
        if (_installMobile != null) {
            return _installMobile!!
        }
        _installMobile = materialIcon(name = "Sharp.InstallMobile") {
            materialPath {
                moveTo(17.0f, 18.0f)
                lineToRelative(-10.0f, 0.0f)
                lineToRelative(0.0f, -12.0f)
                lineToRelative(7.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(-9.0f, 0.0f)
                lineToRelative(0.0f, 22.0f)
                lineToRelative(14.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 14.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-2.59f, 2.58f)
                lineToRelative(0.0f, -7.17f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 7.17f)
                lineToRelative(-2.59f, -2.58f)
                lineToRelative(-1.41f, 1.41f)
                close()
            }
        }
        return _installMobile!!
    }

private var _installMobile: ImageVector? = null
