/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.LightMode: ImageVector
    get() {
        if (_lightMode != null) {
            return _lightMode!!
        }
        _lightMode = materialIcon(name = "Sharp.LightMode") {
            materialPath {
                moveTo(12.0f, 7.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(14.76f, 7.0f, 12.0f, 7.0f)
                lineTo(12.0f, 7.0f)
                close()
                moveTo(11.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(1.0f)
                lineTo(11.0f, 1.0f)
                close()
                moveTo(11.0f, 19.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                lineTo(11.0f, 19.0f)
                close()
                moveTo(23.0f, 11.0f)
                lineToRelative(-4.0f, 0.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(4.0f, 0.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(5.0f, 11.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(4.0f, 0.0f)
                lineTo(5.0f, 11.0f)
                close()
                moveTo(16.24f, 17.66f)
                lineToRelative(2.47f, 2.47f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-2.47f, -2.47f)
                lineTo(16.24f, 17.66f)
                close()
                moveTo(3.87f, 5.28f)
                lineToRelative(2.47f, 2.47f)
                lineToRelative(1.41f, -1.41f)
                lineTo(5.28f, 3.87f)
                lineTo(3.87f, 5.28f)
                close()
                moveTo(6.34f, 16.24f)
                lineToRelative(-2.47f, 2.47f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(2.47f, -2.47f)
                lineTo(6.34f, 16.24f)
                close()
                moveTo(18.72f, 3.87f)
                lineToRelative(-2.47f, 2.47f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(2.47f, -2.47f)
                lineTo(18.72f, 3.87f)
                close()
            }
        }
        return _lightMode!!
    }

private var _lightMode: ImageVector? = null
