/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.LocalFireDepartment: ImageVector
    get() {
        if (_localFireDepartment != null) {
            return _localFireDepartment!!
        }
        _localFireDepartment = materialIcon(name = "Sharp.LocalFireDepartment") {
            materialPath {
                moveTo(19.48f, 12.37f)
                curveTo(17.82f, 8.05f, 11.65f, 8.0f, 13.99f, 0.99f)
                curveTo(9.52f, 3.0f, 5.98f, 8.17f, 9.48f, 15.0f)
                curveTo(4.53f, 12.92f, 6.7f, 7.71f, 6.7f, 7.71f)
                reflectiveCurveTo(4.0f, 9.37f, 4.0f, 14.39f)
                curveToRelative(0.38f, 5.6f, 5.11f, 7.32f, 6.81f, 7.54f)
                curveToRelative(2.43f, 0.31f, 5.06f, -0.14f, 6.95f, -1.87f)
                curveTo(19.84f, 18.13f, 20.6f, 15.05f, 19.48f, 12.37f)
                close()
                moveTo(10.2f, 17.4f)
                curveToRelative(1.44f, -0.35f, 2.18f, -1.39f, 2.38f, -2.31f)
                curveToRelative(0.33f, -1.43f, -0.96f, -2.83f, -0.09f, -5.09f)
                curveToRelative(0.33f, 1.87f, 3.27f, 3.04f, 3.27f, 5.08f)
                curveTo(15.84f, 17.61f, 13.1f, 19.78f, 10.2f, 17.4f)
                close()
            }
        }
        return _localFireDepartment!!
    }

private var _localFireDepartment: ImageVector? = null
