/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MobileOff: ImageVector
    get() {
        if (_mobileOff != null) {
            return _mobileOff!!
        }
        _mobileOff = materialIcon(name = "Sharp.MobileOff") {
            materialPath {
                moveTo(17.0f, 5.0f)
                verticalLineToRelative(8.61f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(1.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(0.61f)
                lineTo(8.39f, 5.0f)
                close()
                moveTo(2.9f, 2.35f)
                lineTo(1.49f, 3.76f)
                lineTo(5.0f, 7.27f)
                verticalLineTo(23.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-1.73f)
                lineToRelative(1.7f, 1.7f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.9f, 2.35f)
                close()
                moveTo(7.0f, 19.0f)
                verticalLineTo(9.27f)
                lineTo(16.73f, 19.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _mobileOff!!
    }

private var _mobileOff: ImageVector? = null
