/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.OpenInNewOff: ImageVector
    get() {
        if (_openInNewOff != null) {
            return _openInNewOff!!
        }
        _openInNewOff = materialIcon(name = "Sharp.OpenInNewOff") {
            materialPath {
                moveTo(16.79f, 5.8f)
                lineTo(14.0f, 3.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(-2.79f, -2.8f)
                lineToRelative(-4.09f, 4.09f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(16.79f, 5.8f)
                close()
                moveTo(19.0f, 12.0f)
                verticalLineToRelative(4.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(12.0f)
                horizontalLineTo(19.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineTo(18.17f, 21.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(5.83f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(16.17f, 19.0f)
                lineToRelative(-4.88f, -4.88f)
                lineTo(9.7f, 15.71f)
                lineTo(8.29f, 14.3f)
                lineToRelative(1.59f, -1.59f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(19.0f)
                horizontalLineTo(16.17f)
                close()
                moveTo(7.83f, 5.0f)
                horizontalLineTo(12.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(5.83f)
                lineTo(7.83f, 5.0f)
                close()
            }
        }
        return _openInNewOff!!
    }

private var _openInNewOff: ImageVector? = null
