/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PlayDisabled: ImageVector
    get() {
        if (_playDisabled != null) {
            return _playDisabled!!
        }
        _playDisabled = materialIcon(name = "Sharp.PlayDisabled") {
            materialPath {
                moveTo(16.45f, 13.62f)
                lineToRelative(2.55f, -1.62f)
                lineToRelative(-11.0f, -7.0f)
                lineToRelative(0.0f, 0.17f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineToRelative(-1.42f, 1.41f)
                lineToRelative(6.61f, 6.61f)
                lineToRelative(0.0f, 8.17f)
                lineToRelative(4.99f, -3.18f)
                lineToRelative(6.79f, 6.79f)
                lineToRelative(1.41f, -1.42f)
                close()
            }
        }
        return _playDisabled!!
    }

private var _playDisabled: ImageVector? = null
