/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RampLeft: ImageVector
    get() {
        if (_rampLeft != null) {
            return _rampLeft!!
        }
        _rampLeft = materialIcon(name = "Sharp.RampLeft") {
            materialPath {
                moveTo(13.0f, 21.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.83f)
                lineTo(9.41f, 8.41f)
                lineTo(8.0f, 7.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(13.0f, 6.83f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, 4.27f, 4.03f, 7.13f, 6.0f, 8.27f)
                lineToRelative(-1.46f, 1.46f)
                curveToRelative(-1.91f, -1.16f, -3.44f, -2.53f, -4.54f, -4.02f)
                lineTo(13.0f, 21.0f)
                close()
            }
        }
        return _rampLeft!!
    }

private var _rampLeft: ImageVector? = null
