/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Scoreboard: ImageVector
    get() {
        if (_scoreboard != null) {
            return _scoreboard!!
        }
        _scoreboard = materialIcon(name = "Sharp.Scoreboard") {
            materialPath {
                moveTo(17.5f, 13.5f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(13.5f)
                close()
                moveTo(22.0f, 4.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(9.5f, 12.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(15.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-3.5f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(4.5f)
                verticalLineTo(12.5f)
                close()
                moveTo(12.75f, 18.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(18.0f)
                close()
                moveTo(12.75f, 14.5f)
                horizontalLineToRelative(-1.5f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(14.5f)
                close()
                moveTo(12.75f, 11.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineTo(9.5f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(11.0f)
                close()
                moveTo(12.75f, 7.5f)
                horizontalLineToRelative(-1.5f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(7.5f)
                close()
                moveTo(19.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-4.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(19.0f)
                close()
            }
        }
        return _scoreboard!!
    }

private var _scoreboard: ImageVector? = null
