/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Tungsten: ImageVector
    get() {
        if (_tungsten != null) {
            return _tungsten!!
        }
        _tungsten = materialIcon(name = "Sharp.Tungsten") {
            materialPath {
                moveTo(11.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(15.8941f, 17.8014f)
                lineToRelative(1.4071f, -1.4071f)
                lineToRelative(2.1213f, 2.1213f)
                lineToRelative(-1.4071f, 1.4071f)
                close()
            }
            materialPath {
                moveTo(4.5842f, 18.5085f)
                lineToRelative(2.1213f, -2.1213f)
                lineToRelative(1.4071f, 1.4071f)
                lineToRelative(-2.1213f, 2.1213f)
                close()
            }
            materialPath {
                moveTo(15.0f, 8.02f)
                verticalLineTo(3.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(5.02f)
                curveTo(7.79f, 8.94f, 7.0f, 10.37f, 7.0f, 12.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                curveTo(17.0f, 10.37f, 16.21f, 8.94f, 15.0f, 8.02f)
                close()
                moveTo(11.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.1f)
                curveTo(12.68f, 7.04f, 12.34f, 7.0f, 12.0f, 7.0f)
                reflectiveCurveToRelative(-0.68f, 0.04f, -1.0f, 0.1f)
                verticalLineTo(5.0f)
                close()
            }
        }
        return _tungsten!!
    }

private var _tungsten: ImageVector? = null
