/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WifiOff: ImageVector
    get() {
        if (_wifiOff != null) {
            return _wifiOff!!
        }
        _wifiOff = materialIcon(name = "Sharp.WifiOff") {
            materialPath {
                moveTo(21.0f, 11.0f)
                lineToRelative(2.0f, -2.0f)
                curveToRelative(-3.73f, -3.73f, -8.87f, -5.15f, -13.7f, -4.31f)
                lineToRelative(2.58f, 2.58f)
                curveToRelative(3.3f, -0.02f, 6.61f, 1.22f, 9.12f, 3.73f)
                close()
                moveTo(9.0f, 17.0f)
                lineToRelative(3.0f, 3.0f)
                lineToRelative(3.0f, -3.0f)
                curveToRelative(-1.65f, -1.66f, -4.34f, -1.66f, -6.0f, 0.0f)
                close()
                moveTo(19.0f, 13.0f)
                curveToRelative(-1.08f, -1.08f, -2.36f, -1.85f, -3.72f, -2.33f)
                lineToRelative(3.02f, 3.02f)
                lineToRelative(0.7f, -0.69f)
                close()
                moveTo(3.41f, 1.64f)
                lineTo(2.0f, 3.05f)
                lineTo(5.05f, 6.1f)
                curveTo(3.59f, 6.83f, 2.22f, 7.79f, 1.0f, 9.0f)
                lineToRelative(2.0f, 2.0f)
                curveToRelative(1.23f, -1.23f, 2.65f, -2.16f, 4.17f, -2.78f)
                lineToRelative(2.24f, 2.24f)
                curveTo(7.79f, 10.89f, 6.27f, 11.74f, 5.0f, 13.0f)
                lineToRelative(2.0f, 2.0f)
                curveToRelative(1.35f, -1.35f, 3.11f, -2.04f, 4.89f, -2.06f)
                lineToRelative(7.08f, 7.08f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.41f, 1.64f)
                close()
            }
        }
        return _wifiOff!!
    }

private var _wifiOff: ImageVector? = null
