/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WindPower: ImageVector
    get() {
        if (_windPower != null) {
            return _windPower!!
        }
        _windPower = materialIcon(name = "Sharp.WindPower") {
            materialPath {
                moveTo(4.0f, 3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
            materialPath {
                moveTo(1.0f, 7.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 19.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(15.32f, 12.09f)
                lineToRelative(5.42f, -9.04f)
                lineTo(17.32f, 1.0f)
                lineTo(12.0f, 5.97f)
                verticalLineToRelative(4.74f)
                curveToRelative(0.31f, -0.13f, 0.64f, -0.21f, 1.0f, -0.21f)
                curveTo(14.06f, 10.5f, 14.96f, 11.16f, 15.32f, 12.09f)
                close()
            }
            materialPath {
                moveTo(10.5f, 13.0f)
                curveToRelative(0.0f, -0.82f, 0.4f, -1.54f, 1.01f, -2.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(7.0f, 2.0f)
                lineToRelative(3.44f, -2.06f)
                curveTo(10.87f, 14.48f, 10.5f, 13.79f, 10.5f, 13.0f)
                close()
            }
            materialPath {
                moveTo(20.17f, 23.0f)
                lineTo(23.0f, 20.17f)
                lineToRelative(-3.54f, -6.36f)
                lineToRelative(-3.98f, -1.0f)
                curveToRelative(0.0f, 0.06f, 0.02f, 0.12f, 0.02f, 0.19f)
                curveToRelative(0.0f, 1.38f, -1.12f, 2.5f, -2.5f, 2.5f)
                curveToRelative(-0.36f, 0.0f, -0.69f, -0.08f, -1.0f, -0.21f)
                verticalLineTo(21.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                verticalLineToRelative(-4.17f)
                lineTo(20.17f, 23.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 13.0f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _windPower!!
    }

private var _windPower: ImageVector? = null
