/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BrowseGallery: ImageVector
    get() {
        if (_browseGallery != null) {
            return _browseGallery!!
        }
        _browseGallery = materialIcon(name = "TwoTone.BrowseGallery") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.0f, 5.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, 3.14f, -7.0f, 7.0f)
                reflectiveCurveToRelative(3.14f, 7.0f, 7.0f, 7.0f)
                reflectiveCurveToRelative(7.0f, -3.14f, 7.0f, -7.0f)
                reflectiveCurveTo(12.86f, 5.0f, 9.0f, 5.0f)
                close()
                moveTo(11.79f, 16.21f)
                lineTo(8.0f, 12.41f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.59f)
                lineToRelative(3.21f, 3.21f)
                lineTo(11.79f, 16.21f)
                close()
            }
            materialPath {
                moveTo(9.0f, 3.0f)
                curveToRelative(-4.97f, 0.0f, -9.0f, 4.03f, -9.0f, 9.0f)
                reflectiveCurveToRelative(4.03f, 9.0f, 9.0f, 9.0f)
                reflectiveCurveToRelative(9.0f, -4.03f, 9.0f, -9.0f)
                reflectiveCurveTo(13.97f, 3.0f, 9.0f, 3.0f)
                close()
                moveTo(9.0f, 19.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, -3.14f, -7.0f, -7.0f)
                reflectiveCurveToRelative(3.14f, -7.0f, 7.0f, -7.0f)
                reflectiveCurveToRelative(7.0f, 3.14f, 7.0f, 7.0f)
                reflectiveCurveTo(12.86f, 19.0f, 9.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 7.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 5.41f)
                lineToRelative(3.79f, 3.8f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(-3.21f, -3.2f)
                close()
            }
            materialPath {
                moveTo(17.99f, 3.52f)
                verticalLineToRelative(2.16f)
                curveTo(20.36f, 6.8f, 22.0f, 9.21f, 22.0f, 12.0f)
                curveToRelative(0.0f, 2.79f, -1.64f, 5.2f, -4.01f, 6.32f)
                verticalLineToRelative(2.16f)
                curveTo(21.48f, 19.24f, 24.0f, 15.91f, 24.0f, 12.0f)
                curveTo(24.0f, 8.09f, 21.48f, 4.76f, 17.99f, 3.52f)
                close()
            }
        }
        return _browseGallery!!
    }

private var _browseGallery: ImageVector? = null
