/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.JoinFull: ImageVector
    get() {
        if (_joinFull != null) {
            return _joinFull!!
        }
        _joinFull = materialIcon(name = "TwoTone.JoinFull") {
            materialPath {
                moveTo(9.0f, 12.0f)
                arcToRelative(3.0f, 5.74f, 0.0f, true, false, 6.0f, 0.0f)
                arcToRelative(3.0f, 5.74f, 0.0f, true, false, -6.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(7.5f, 12.0f)
                curveToRelative(0.0f, -0.97f, 0.23f, -4.16f, 3.03f, -6.5f)
                curveTo(9.75f, 5.19f, 8.9f, 5.0f, 8.0f, 5.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, 3.14f, -7.0f, 7.0f)
                reflectiveCurveToRelative(3.14f, 7.0f, 7.0f, 7.0f)
                curveToRelative(0.9f, 0.0f, 1.75f, -0.19f, 2.53f, -0.5f)
                curveTo(7.73f, 16.16f, 7.5f, 12.97f, 7.5f, 12.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 5.0f)
                curveToRelative(-0.9f, 0.0f, -1.75f, 0.19f, -2.53f, 0.5f)
                curveToRelative(2.8f, 2.34f, 3.03f, 5.53f, 3.03f, 6.5f)
                curveToRelative(0.0f, 0.97f, -0.23f, 4.16f, -3.03f, 6.5f)
                curveTo(14.25f, 18.81f, 15.1f, 19.0f, 16.0f, 19.0f)
                curveToRelative(3.86f, 0.0f, 7.0f, -3.14f, 7.0f, -7.0f)
                reflectiveCurveTo(19.86f, 5.0f, 16.0f, 5.0f)
                close()
            }
        }
        return _joinFull!!
    }

private var _joinFull: ImageVector? = null
