/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.KeyboardCommandKey: ImageVector
    get() {
        if (_keyboardCommandKey != null) {
            return _keyboardCommandKey!!
        }
        _keyboardCommandKey = materialIcon(name = "TwoTone.KeyboardCommandKey") {
            materialPath {
                moveTo(17.5f, 3.0f)
                curveTo(15.57f, 3.0f, 14.0f, 4.57f, 14.0f, 6.5f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(6.5f)
                curveTo(10.0f, 4.57f, 8.43f, 3.0f, 6.5f, 3.0f)
                reflectiveCurveTo(3.0f, 4.57f, 3.0f, 6.5f)
                reflectiveCurveTo(4.57f, 10.0f, 6.5f, 10.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(6.5f)
                curveTo(4.57f, 14.0f, 3.0f, 15.57f, 3.0f, 17.5f)
                reflectiveCurveTo(4.57f, 21.0f, 6.5f, 21.0f)
                reflectiveCurveToRelative(3.5f, -1.57f, 3.5f, -3.5f)
                verticalLineTo(16.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(1.5f)
                curveToRelative(0.0f, 1.93f, 1.57f, 3.5f, 3.5f, 3.5f)
                reflectiveCurveToRelative(3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveTo(19.43f, 14.0f, 17.5f, 14.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveTo(19.43f, 3.0f, 17.5f, 3.0f)
                lineTo(17.5f, 3.0f)
                close()
                moveTo(16.0f, 8.0f)
                verticalLineTo(6.5f)
                curveTo(16.0f, 5.67f, 16.67f, 5.0f, 17.5f, 5.0f)
                reflectiveCurveTo(19.0f, 5.67f, 19.0f, 6.5f)
                reflectiveCurveTo(18.33f, 8.0f, 17.5f, 8.0f)
                horizontalLineTo(16.0f)
                lineTo(16.0f, 8.0f)
                close()
                moveTo(6.5f, 8.0f)
                curveTo(5.67f, 8.0f, 5.0f, 7.33f, 5.0f, 6.5f)
                reflectiveCurveTo(5.67f, 5.0f, 6.5f, 5.0f)
                reflectiveCurveTo(8.0f, 5.67f, 8.0f, 6.5f)
                verticalLineTo(8.0f)
                horizontalLineTo(6.5f)
                lineTo(6.5f, 8.0f)
                close()
                moveTo(10.0f, 14.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(10.0f)
                lineTo(10.0f, 14.0f)
                close()
                moveTo(17.5f, 19.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                verticalLineTo(16.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(18.33f, 19.0f, 17.5f, 19.0f)
                lineTo(17.5f, 19.0f)
                close()
                moveTo(6.5f, 19.0f)
                curveTo(5.67f, 19.0f, 5.0f, 18.33f, 5.0f, 17.5f)
                reflectiveCurveTo(5.67f, 16.0f, 6.5f, 16.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(1.5f)
                curveTo(8.0f, 18.33f, 7.33f, 19.0f, 6.5f, 19.0f)
                lineTo(6.5f, 19.0f)
                close()
            }
        }
        return _keyboardCommandKey!!
    }

private var _keyboardCommandKey: ImageVector? = null
